#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>

//************************************************************************************
// Program to generate a unique serial number and to maintain a serial number database
// Intended use is to serialize microprocessors as they're programmed.
//
// (C) John DeArmond 2010. A little bit of righs reserved.
// 
// This is freeware.  Use it, abuse it but leave my name attached.
//
// Known Weaknes
//	Requires an existing serial number file.  You can create one with a text
//	editor.  Simply open a new file and write the following
//	0<tab>xxxxxxxxxxxxxxxxxxxx
//	That is the number 0, a tab and around 20 characters of your choice.
// 	The first serial number returned will thus be 0000000001
//
//	Serial number is limited to 10 digits.  If that's not enough, feel free to
//	change it below.
//
//	Buffers can be over-run with over 500 characters to a record or a path more than 
//	500 characters long. Live with it!
//
// John, jgd@fluxeon.com
//**************************************************************************************

// #define DEBUG

char version[] ="1.02 09/01/2010";
char progname[] = "ser_no";

char ser_no_file[500];		// path to the serial number file
char date[500];			// system date
char file_name[500];		//  name of the serial number file
char board_rev[500];		// revision number of the board.
long int file_ser_no;		// serial number contained in the file
char file_date[500];		// date contained in the file.
char marker[10];		// holds the record marker

unsigned long ser_no=0; 	// where the serial number is stored
struct stat sb;			// buffer for stat() function
time_t time_val;		// system time as a number since the epoch
FILE *fd;			// file descriptor to file being opened

int repeat = 0;			// if set, this flag causes the last number to be emitted again.
int board_rev_flag = 0;		// Board rev flag has been set

static void usage(void)
{
  fprintf(stderr,
 "Usage: %s [options]\n"
 "Options:\n"
"   -?                         Display this usage.\n"
"   -f file                    File that contains the serial number.\n"
"   -d date                    Over-ride system date.\n"
"   -r                         Repeat the last number\n"
"   -R                         Specify the PCB revision number\n"
"   -e                         rEvert - discard last serial number.\n"
 "\nversion %s \n"
          ,progname, version);
}

// function to remove last record.  This is done via file truncation
int revert_sn() {
long int i;
int foo;
char j;
off_t position;


	chmod(file_name, S_IWUSR |S_IWGRP);  /* set read/write */
//	chmod(file_name, 0066);  /* set  read/write */

	if (!(fd = fopen(file_name, "r+"))) {	// open file for read/write
		chmod(file_name, S_IRUSR |S_IRGRP);  /* set read-only */
		fprintf(stderr,"\nFile %s failed to open\n", file_name);
		exit(1);
	} //if

	// seek to end of file
	if ( fseek(fd,0l,SEEK_END) != 0 ) {
		fprintf(stderr, "Seeking to EOF of file %s failed\n", file_name);
		exit(1);
	}


	//back up through the file until the first newline is found

	i = -2;
	while ( (foo=fseek(fd,i--,SEEK_END)) == 0 ) {
		if ((j=fgetc(fd)) == '\n')
			break;	
	} //while

	if (foo != 0) {
		fprintf(stderr,"No newline character found\n");
		exit(1);
	} //if

	// we've found the newline character so truncate
	position = ftell(fd);
	
	if ((foo=truncate(file_name,position)) != 0) {
		fprintf(stderr, "truncate at position %ld failed\n", position);
		exit(1);
	}

	fclose(fd);
	chmod(file_name, S_IRUSR |S_IRGRP);  /* set read-only */
//	chmod(file_name, 0044);  /* set read-only */



} //revert

int read_serno() {
int s_ret;
char buff[200];
char foo[500];

	chmod(file_name, S_IRUSR |S_IRGRP);  /* set read-only */
//	chmod(file_name, 0044);  /* set read-only */

	if (!(fd = fopen(file_name, "r"))) {	// open file for both reading
		chmod(file_name, S_IRUSR |S_IRGRP);  /* set read-only */
		fprintf(stderr,"\nFile %s failed to open\n", file_name);
		exit(1);
	} //if

	while ( s_ret=fgets(buff,199,fd) !=  NULL   ) {		// when EOF is hit, the last record will be in the variables.
								// yeah, it's a linear crawl but it's fast so who cares?

		if (board_rev_flag) {	// if board rev is specified, throw away the read value of board rev
			if ( s_ret=sscanf(buff,"%ld %s %24c", &file_ser_no, foo, file_date) !=  3   ) {
				break;
			}
		} else {
			if ( s_ret=sscanf(buff,"%ld %s %24c", &file_ser_no, board_rev, file_date) !=  3   ) {
				break;
			}
		}

	}// while
	fclose(fd);

} //read_serno()


int write_serno() {

//	fprintf(stderr,"Entering write_serno()\n");

	if (repeat == 1) 	// we don't do anything to the file if the command is to repeat the serial number.
		return;

	chmod(file_name, S_IWUSR |S_IWGRP);  /* set write only */
//	chmod(file_name, 0066);  /* set write only */

	if (!(fd = fopen(file_name, "a+"))) {	// open file for appending
		chmod(file_name, S_IRUSR |S_IRGRP);  /* set read-only */
		fprintf(stderr,"\nFile %s failed to open\n", file_name);
		exit(1);
	} //if

	file_ser_no++;	//increment for new serial number.

	time_val = time(NULL);
	strcpy(file_date, ctime(&time_val));

	if (strlen(board_rev) == 0 ) {

		strcpy(board_rev,"0000");
	}

	fprintf(fd, "%10.10ld\t%s\t%s", file_ser_no,board_rev,file_date);
	
	fclose(fd);
	chmod(file_name, S_IRUSR |S_IRGRP);  /* set read-only */
//	chmod(file_name, 0044);  /* set read-only */
	return;


} //write_serno

int main(int argc, char *argv[]) {
	int ch,i;			//option character storage
	int fn_speced = 0;	// if set then file name has been spedified with -f
	int revert_flag = 0;
	char tmp_store[100];

	board_rev[0] = 0; 	// make sure the string is empty


	while ((ch = getopt(argc,argv,"?herR:df:")) != -1) {

	    switch (ch) {

	      case 'e':	// revert - dump last serial number record
		revert_flag = 1;
		break;
	
	      case 'f':
		fn_speced = 1;
		if (stat(optarg, &sb)) {
		  fprintf(stderr, "%s: File '%s does not exist.\n", progname, optarg);
		  exit(1);
		}
		strcpy(file_name, optarg);
		break;

		case 'd':
			time_val = time(NULL);
			strcpy(date, ctime(&time_val));
			break;

		case 'r':	//repeat the last output
			repeat = 1;
			break;

		case 'R':	// store the argument as the PCB revision number
			strcpy(board_rev, optarg);
			board_rev_flag =1;
			break;	
		
		case '?':
		case 'h':
			usage();
			exit(1);

		default:
			fprintf(stderr,"invalid argument\n");
			usage();
			exit(1);
		} //switch
	} //while ch	


// if the file name hasn't been spec'd then try to open it in the invoking directory

	if (!fn_speced) {
		strcpy(file_name, "./serial_no.txt");
		if (stat(file_name, &sb)) {
		  fprintf(stderr, "%s: File '%s does not exist.\n", progname, file_name);
		  exit(1);
		}

	} // if fn_speced




	read_serno();

#ifdef DEBUG
	fprintf(stderr, "Reading file %s\n", file_name);

	fprintf(stderr,"last record read: %ld\t%s\n", file_ser_no, file_date);
#endif

	if (revert_flag) 
		revert_sn();
	else { 
		write_serno();
		
		sprintf(tmp_store,"%10.10ld\n",file_ser_no);	// output to calling shell script

		i=0;
		while (tmp_store[i] != 0 ) {
		putchar(tmp_store[i++]);
		if (tmp_store[i+1] !=0)
			putchar(',');

		}
	}
	exit(0);

} //main
